local t = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,{0,0,0,.5};Center);
	};
	LoadFont("_ubuntu Italic 35px")..{
		Text="SWITCH DEBUGGER";
		InitCommand=cmd(horizalign,left;xy,20,25;zoom,1);
	};
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,1;xy,SCREEN_CENTER_X,50;faderight,1);
	}
};


--[[local function getEvNum()
	return saveData['_GLOBAL']['Vars'][1]
end;
local function setEvNum()

end;]]
local function getEvName()
	local evNum = saveData['_GLOBAL']['Vars'][1]
	return evNum..": "..(DEBUG_FLAG_NAMES[evNum] or "Unknown Event")
end;

--
--local eventNumPointer = saveData['_GLOBAL']['EventNum']
--eventNumPointer=9
--Trace('val '..saveData['_GLOBAL']['EventNum'])

local as = Def.ActorScroller{
    NumItemsToDraw=(#saveData['_GLOBAL']['Flags']+1)*2, 
    SecondsPerItem=0,
    TransformFunction=function(self,offset,itemIndex,numItems)
        self:y(30*offset);
    end,

    InitCommand=cmd(xy,100,100;SetFastCatchup,true),
    OnCommand=function(self)
    	self:GetChild(1):playcommand("GainFocus")
    end;
    --This is the input handler for the scroller.
    CodeMessageCommand=function(self, param)
        if param.Name == "MenuUp" then
            if self:GetDestinationItem() > 0 then
                self:SetDestinationItem(self:GetDestinationItem()-1);
                SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
            end;
        elseif param.Name == "MenuDown" then
            if self:GetDestinationItem() < self:GetNumItems()-1 then
                self:SetDestinationItem(self:GetDestinationItem()+1);
                SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
            end;
        elseif param.Name == "MenuLeft" then
        	--We don't have a metatable sooooooo
        	if self:GetDestinationItem() == 0 and saveData['_GLOBAL']['Vars'][1] > 1 then
        		saveData['_GLOBAL']['Vars'][1] = saveData['_GLOBAL']['Vars'][1]-1
        		self:GetChild(self:GetDestinationItem()+1):GetChild('var'):settext(getEvName())
        	end;
        elseif param.Name == "MenuRight" then
        	if self:GetDestinationItem() == 0 then --No limit
        		saveData['_GLOBAL']['Vars'][1] = saveData['_GLOBAL']['Vars'][1]+1
        		self:GetChild(self:GetDestinationItem()+1):GetChild('var'):settext(getEvName())
        	end;
        elseif param.Name == "Start" then
        	saveData['_GLOBAL']['Flags'][self:GetDestinationItem()+1] = not saveData['_GLOBAL']['Flags'][self:GetDestinationItem()+1]
        	self:GetChild(self:GetDestinationItem()+1):GetChild('bool'):settext(boolToString(saveData['_GLOBAL']['Flags'][self:GetDestinationItem()+1]))
            --SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
        elseif param.Name == "Back" then
        	MESSAGEMAN:Broadcast("EventExited")
            SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
        else
        	--SCREENMAN:SystemMessage("Unknown Button "..param.Name);
        end;

        --GainFocus and LoseFocus aren't part of ActorScroller, they're part of ScreenSelectMaster. So we'll reimplement them.
        for i=1,self:GetNumItems() do
            -- C++ is 0-indexed while lua is 1-indexed. So 0 is the minimum for an ActorScroller even though lua items start at 1.
            if self:GetDestinationItem() == i-1 then
                self:GetChild(i):playcommand("GainFocus")
            else
                self:GetChild(i):playcommand("LoseFocus")
            end;
        end;
    end
}

as[#as+1] = Def.ActorFrame{
	Name=1; --Do not forget this! You need to give the items an index for GainFocus and LoseFocus to work!
	LoadFont("Common Normal")..{
		Text="Current Event";
		InitCommand=cmd(horizalign,left);
		GainFocusCommand=cmd(diffuse,Color("Red"));
		LoseFocusCommand=cmd(diffuse,Color("White"));
	};
	LoadFont("Common Normal")..{
		Name="var";
		Text=getEvName();
		InitCommand=cmd(horizalign,left;x,500);
		GainFocusCommand=cmd(diffuse,Color("Red"));
		LoseFocusCommand=cmd(diffuse,Color("White"));
		
	}
}

for i,v in ipairs(saveData['_GLOBAL']['Flags']) do
	--Need to wrap in an ActorFrame for GainFocus & LoseFocus to work properly.
    as[#as+1] = Def.ActorFrame{
        Name=i+1; --Do not forget this! You need to give the items an index for GainFocus and LoseFocus to work!
        LoadFont("Common Normal")..{
        	Text="???";
            --Text=DEBUG_FLAG_NAMES[i] or i;
            InitCommand=cmd(horizalign,left);
            GainFocusCommand=cmd(diffuse,Color("Red"));
            LoseFocusCommand=cmd(diffuse,Color("White"));
        };
        LoadFont("Common Normal")..{
        	Name="bool";
        	Text=boolToString(v);
        	InitCommand=cmd(horizalign,left;x,500);
            GainFocusCommand=cmd(diffuse,Color("Red"));
            LoseFocusCommand=cmd(diffuse,Color("White"));
        	
        }
    };
end;

t[#t+1]=as;

return t;
